package w83b.w83bOperacionesPaso.w83bListados.w83bDelegados;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.apache.commons.lang.StringUtils;
import org.apache.poi.hssf.usermodel.HSSFCell;
import org.apache.poi.hssf.usermodel.HSSFCellStyle;

import org.apache.poi.hssf.usermodel.HSSFRow;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.hssf.util.Region;
import org.apache.struts.action.ActionErrors;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;

import w83b.w83bBeans.W83bListadosBean;
import w83b.w83bBeans.W83bUsuarioXLNetsBean;
import w83b.w83bUtilidades.W83bUtilidadesExcel;
import w83b.w83bUtilidadesComunes.W83bClsConstantes;

import w83b.w83bUtilidadesComunes.W83bUtilidadesN38API;
import es.ejie.frmk.infraestructura.internacionalizacion.Q70GestorMensajesi18n;
import es.ejie.frmk.listeners.base.Q70ListenerUtils;
import es.ejie.frmk.presentacion.operacion.paso.Q70ActionPasoOP;
import es.ejie.frmk.presentacion.sesiondatos.Q70ContextoEJIE;

// TODO: Auto-generated Javadoc
/**
 * The Class W83bTablaConveniosOP.java.
 *
 * @author Deusto Sistemas
 */
public class W83bTablaLibroRelacionBajasExcelAction extends Q70ActionPasoOP{


	
	protected void processOP(Q70ContextoEJIE contexto, ActionErrors errores, ActionMapping mapping,
			ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
		
		
	}

	protected ActionForward processForward(Q70ContextoEJIE contexto, ActionErrors errors, ActionMapping mapping, 
			ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {

		String strRutaExcel = Q70ListenerUtils.getApplicationProperty("RUTA_PLANTILLAS_EXCEL")+"plantillaExcelw83bRelacionBajas.xls";
		InputStream inputStream = W83bTablaLibroRelacionBajasExcelAction.class.getResourceAsStream(strRutaExcel);
		HSSFWorkbook wb = new HSSFWorkbook(inputStream);
		
		wb.setSheetName(0,"Hoja1"); // Creacin de la hoja
        HSSFSheet sheet = wb.getSheetAt(0); // Creacin de la hoja
        
        List listaLibroRelacionBajas = (ArrayList)contexto.get("w83bResultadoListadosBean");
        W83bListadosBean listadoBean = (W83bListadosBean)contexto.get("w83bListadosBean");
        
        W83bUtilidadesExcel excel = new W83bUtilidadesExcel(wb);

        String idioma = (String)contexto.get(W83bClsConstantes.CONSTANTE_CONTEXTO_IDIOMA);
        
        W83bUtilidadesExcel.crearCabeceraPieEstandar(sheet, idioma,(W83bUsuarioXLNetsBean)contexto.get(W83bClsConstantes.CONSTANTE_CONTEXTO_USUARIO));      
        
        W83bUsuarioXLNetsBean usuario = (W83bUsuarioXLNetsBean)contexto.get(W83bClsConstantes.CONSTANTE_CONTEXTO_USUARIO);
        String provincia = W83bUtilidadesN38API.elegirProvinciaDelegacion(usuario.getPerfilXLNets());       
        
        HSSFRow row;
        HSSFCell cell;
        HSSFCell cell2;
        HSSFCell cell3;
        HSSFCell cell4;
        HSSFCell cell5;
        
        row = sheet.getRow((short)4); 
        cell = row.getCell((short)5);
        StringBuffer tituloImagenEu = new StringBuffer();
        StringBuffer tituloImagenEs = new StringBuffer();
        
        tituloImagenEu.append(Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun","comun.informes.tituloImagenInforme_eu",idioma));
        tituloImagenEs.append(Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun","comun.informes.tituloImagenInforme_es",idioma));
        
        cell.setCellValue(tituloImagenEu.toString());
        cell = row.getCell((short)7); 
        sheet.addMergedRegion(new Region((short)4,(short)7,(short)4,(short)8)); //NOPMD
        cell.setCellValue(tituloImagenEs.toString());
        tituloImagenEu = new StringBuffer();
        tituloImagenEs = new StringBuffer();
        if(W83bClsConstantes.CONSTANTE_SERVICIOS_CENTRALES.equals(provincia)){
        	tituloImagenEu.append(Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun","comun.informes.direccionTrabajo_eu",idioma));
        	tituloImagenEs.append(Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun","comun.informes.direccionTrabajo_es",idioma));
        }
        else if(W83bClsConstantes.CONSTANTE_ALAVA.equals(provincia)){
        	tituloImagenEu.append(Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun","comun.informes.delegacionAlava_eu",idioma));
        	tituloImagenEs.append(Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun","comun.informes.delegacionAlava_es",idioma));
        }else if(W83bClsConstantes.CONSTANTE_GIPUZKOA.equals(provincia)){
        	tituloImagenEu.append(Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun","comun.informes.delegacionGuipuzcoa_eu",idioma));
        	tituloImagenEs.append(Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun","comun.informes.delegacionGuipuzcoa_es",idioma));
        }else if(W83bClsConstantes.CONSTANTE_BIZKAIA.equals(provincia)){
        	tituloImagenEu.append(Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun","comun.informes.delegacionBizkaia_eu",idioma));        	
        	tituloImagenEs.append(Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun","comun.informes.delegacionBizkaia_es",idioma));        	
        }
        	
        
        
        
        row = sheet.getRow((short)6); 
        cell = row.getCell((short)5);
        cell.setCellValue(tituloImagenEu.toString());
        
        cell = row.getCell((short)7); 
        sheet.addMergedRegion(new Region((short)6,(short)7,(short)6,(short)8)); //NOPMD
        cell.setCellValue(tituloImagenEs.toString());
               
        //MAPEO FORMULARIO
        row = sheet.getRow((short)11); 
        
        cell = row.createCell((short)1); 
        if(StringUtils.isNotEmpty(listadoBean.getDescTerritorio())){
        	cell.setCellValue(listadoBean.getDescTerritorio());
        }
       
        cell = row.createCell((short)7); 
        cell2 = row.createCell((short)8); 
        sheet.addMergedRegion(new Region((short)11,(short)7,(short)11,(short)8)); //NOPMD
        if(StringUtils.isNotEmpty(listadoBean.getFechaBajaDesde())){
        	cell.setCellValue(listadoBean.getFechaBajaDesde());
        }
        
        cell = row.createCell((short)11); 
        cell2 = row.createCell((short)12); 
        sheet.addMergedRegion(new Region((short)11,(short)11,(short)11,(short)12)); //NOPMD
        if(StringUtils.isNotEmpty(listadoBean.getFechaBajaHasta())){
        	cell.setCellValue(listadoBean.getFechaBajaHasta());
        }
        W83bListadosBean relacion=new W83bListadosBean();
        int p=0;
        for(int i=0;i<listaLibroRelacionBajas.size();i++){
        	relacion=(W83bListadosBean)listaLibroRelacionBajas.get(i);
        	row = sheet.createRow((short)15+p); // Creacin de la fila 1
        	
        	cell = row.createCell((short)0); 
        	if(StringUtils.isNotEmpty(relacion.getNumActa())){
        		cell.setCellValue(relacion.getNumActa());
        	}
        	cell.setCellStyle(estiloFilaBordeIzquierdaArribaNegrita(p,excel));
        	
        	cell = row.createCell((short)1); 
        	cell2 = row.createCell((short)2); 
        	cell3 = row.createCell((short)3); 
        	cell4 = row.createCell((short)4); 
        	cell5 = row.createCell((short)5); 
        	sheet.addMergedRegion(new Region((short)15+p,(short)1,(short)15+p,(short)5)); //NOPMD
        	if(StringUtils.isNotEmpty(relacion.getRazon())){
        		cell.setCellValue(relacion.getRazon());
        	}
        	cell.setCellStyle(estiloFilaBordeArriba(p,excel));
        	cell2.setCellStyle(estiloFilaBordeArriba(p,excel));
        	cell3.setCellStyle(estiloFilaBordeArriba(p,excel));
        	cell4.setCellStyle(estiloFilaBordeArriba(p,excel));
        	cell5.setCellStyle(estiloFilaBordeDerechaArriba(p,excel));
        	        	
        	cell = row.createCell((short)7); 
        	cell.setCellValue(Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun","comun.informes.delegados.sale",idioma)+":");
     		cell.setCellStyle(estiloFilaBordeIzquierdaArriba(p,excel));
     		
     		
        	cell = row.createCell((short)8); 
        	cell2 = row.createCell((short)9); 
        	sheet.addMergedRegion(new Region((short)15+p,(short)8,(short)15+p,(short)9)); //NOPMD
        	if(StringUtils.isNotEmpty(relacion.getNombre())){
        		cell.setCellValue(relacion.getNombre());
        	}
        	cell.setCellStyle(estiloFilaBordeArriba(p,excel));
        	cell2.setCellStyle(estiloFilaBordeArriba(p,excel));
        	
        	cell = row.createCell((short)10); 
        	cell.setCellValue(Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun","comun.informes.delegados.sindicato",idioma)+":");
        	cell.setCellStyle(estiloFilaBordeArriba(p,excel));
        	
        	cell = row.createCell((short)11); 
        	if(StringUtils.isNotEmpty(relacion.getSindicato())){
        		cell.setCellValue(relacion.getSindicato());
        	}
        	cell.setCellStyle(estiloFilaBordeArriba(p,excel));
        	
        	cell = row.createCell((short)12); 
        	cell.setCellValue(Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun","comun.informes.delegados.dni",idioma)+":");
        	cell.setCellStyle(estiloFilaBordeArriba(p,excel));
        	
        	cell = row.createCell((short)13); 
        	if(StringUtils.isNotEmpty(relacion.getDni())){
        		cell.setCellValue(relacion.getDni());
        	}
        	cell.setCellStyle(estiloFilaBordeDerechaArriba(p,excel));
        	
        	
        	p++;
        	row = sheet.createRow((short)15+p);
        	
        	cell = row.createCell((short)0); 
        	if(StringUtils.isNotEmpty(relacion.getFechaBaja())){
        		cell.setCellValue(relacion.getFechaBaja());
        	}
     		cell.setCellStyle(estiloFilaBordeIzquierdaAbajo(p,excel));
     		
        	
        	cell = row.createCell((short)1); 
        	cell.setCellValue(Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun","comun.informes.delegados.organo",idioma)+":");
     		cell.setCellStyle(estiloFilaBordeAbajo(p,excel));
     		
        	cell = row.createCell((short)2); 
        	if(StringUtils.isNotEmpty(relacion.getMaximoDelegados())){
	        	if(Integer.parseInt(relacion.getMaximoDelegados())<5){
	        		cell.setCellValue(Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun","comun.informes.delegados.delegado",idioma));
	        	}
	        	else{
	        		cell.setCellValue(Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun","comun.informes.delegados.comite",idioma));
	        	}
        	}
        	else{
        		cell.setCellValue(Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun","comun.informes.delegados.delegado",idioma));
        	}
        	
        	cell.setCellStyle(estiloFilaBordeAbajo(p,excel));
        	
        	cell = row.createCell((short)3); 
        	cell.setCellValue(Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun","comun.informes.delegados.motivo",idioma)+":");
        	cell.setCellStyle(estiloFilaBordeAbajo(p,excel));
        	
        	cell = row.createCell((short)4); 
        	cell2 = row.createCell((short)5); 
        	sheet.addMergedRegion(new Region((short)15+p,(short)4,(short)15+p,(short)5)); //NOPMD
        	if(StringUtils.isNotEmpty(relacion.getMotivoBaja())){
            	cell.setCellValue(relacion.getMotivoBaja());
            }
        	cell.setCellStyle(estiloFilaBordeDerechaAbajo(p,excel));
        	cell2.setCellStyle(estiloFilaBordeDerechaAbajo(p,excel));
        	
        	
        	cell = row.createCell((short)7); 
        	cell.setCellValue(Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun","comun.informes.delegados.entra",idioma)+":");
        	cell.setCellStyle(estiloFilaBordeIzquierdaAbajo(p,excel));
        	
        	
        	cell = row.createCell((short)8);
        	cell2 = row.createCell((short)9);
        	sheet.addMergedRegion(new Region((short)15+p,(short)8,(short)15+p,(short)9)); //NOPMD
        	if(StringUtils.isNotEmpty(relacion.getNombreSustituto().trim())){
            	cell.setCellValue(relacion.getNombreSustituto());
            }
        	else if(StringUtils.isEmpty(relacion.getDniSustituto())){
        		cell.setCellValue(Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun","comun.informes.delegados.sinCandidato",idioma).toUpperCase());
        	}
        	cell.setCellStyle(estiloFilaBordeAbajo(p,excel));
        	cell2.setCellStyle(estiloFilaBordeAbajo(p,excel));
        	
        	cell = row.createCell((short)10); 
        	cell.setCellValue(Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun","comun.informes.delegados.sindicato",idioma)+":");
        	cell.setCellStyle(estiloFilaBordeAbajo(p,excel));
        	
        	cell = row.createCell((short)11); 
        	if(StringUtils.isNotEmpty(relacion.getSindicatoSustituto())){
            	cell.setCellValue(relacion.getSindicatoSustituto());
            }
        	cell.setCellStyle(estiloFilaBordeAbajo(p,excel));
        	
        	cell = row.createCell((short)12); 
        	cell.setCellValue(Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun","comun.informes.delegados.dni",idioma)+":");
        	cell.setCellStyle(estiloFilaBordeAbajo(p,excel));
        	
        	cell = row.createCell((short)13); 
        	if(StringUtils.isNotEmpty(relacion.getDniSustituto())){
            	cell.setCellValue(relacion.getDniSustituto());
            }
        	cell.setCellStyle(estiloFilaBordeDerechaAbajo(p,excel));
        	p++;
        }
        
		
        byte[] bytesExcel = W83bUtilidadesExcel.fncExcelToBytes(wb);
        
        response.setContentType("application/vnd.ms-excel");
        response.setContentLength(bytesExcel.length);
        response.setHeader("Content-disposition","attachment;filename=listadoRelacionBajas.xls");
        response.getOutputStream().write(bytesExcel);
        response.getOutputStream().flush();

		
		return null;
	}
	/**
	 * Estilo fila borde.
	 * 
	 * @param nFila the n fila
	 * @param excel the excel
	 * @return the hSSF cell style
	 */
	private HSSFCellStyle estiloFilaBordeAbajo(int nFila, W83bUtilidadesExcel excel){
		return excel.styleBordeAbajo;
		
		
	}
	/**
	 * Estilo fila borde.
	 * 
	 * @param nFila the n fila
	 * @param excel the excel
	 * @return the hSSF cell style
	 */
	private HSSFCellStyle estiloFilaBordeArriba(int nFila, W83bUtilidadesExcel excel){
		return excel.styleBordeArriba;
		
		
	}
	/**
	 * Estilo fila borde.
	 * 
	 * @param nFila the n fila
	 * @param excel the excel
	 * @return the hSSF cell style
	 */
	private HSSFCellStyle estiloFilaBordeDerechaAbajo(int nFila, W83bUtilidadesExcel excel){
		return excel.styleBordeDchaAbajo;
		
		
	}
	/**
	 * Estilo fila borde.
	 * 
	 * @param nFila the n fila
	 * @param excel the excel
	 * @return the hSSF cell style
	 */
	private HSSFCellStyle estiloFilaBordeIzquierdaAbajo(int nFila, W83bUtilidadesExcel excel){
		return excel.styleBordeIzdaAbajo;
		
		
	}
	/**
	 * Estilo fila borde.
	 * 
	 * @param nFila the n fila
	 * @param excel the excel
	 * @return the hSSF cell style
	 */
	private HSSFCellStyle estiloFilaBordeDerechaArriba(int nFila, W83bUtilidadesExcel excel){
		return excel.styleBordeDchaArriba;
		
		
	}
	/**
	 * Estilo fila borde.
	 * 
	 * @param nFila the n fila
	 * @param excel the excel
	 * @return the hSSF cell style
	 */
	private HSSFCellStyle estiloFilaBordeIzquierdaArriba(int nFila, W83bUtilidadesExcel excel){
		return excel.styleBordeIzdaArriba;
		
		
	}
	/**
	 * Estilo fila borde.
	 * 
	 * @param nFila the n fila
	 * @param excel the excel
	 * @return the hSSF cell style
	 */
	private HSSFCellStyle estiloFilaBordeIzquierdaArribaNegrita(int nFila, W83bUtilidadesExcel excel){
		return excel.styleBordeIzdaArribaNegrita;
		
		
	}


}
